package jamezo97.clonecraft.sounds;

import jamezo97.clonecraft.Reflect;

import java.net.URL;
import java.util.List;
import java.util.Map;

import net.minecraft.client.audio.SoundPoolEntry;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.event.ForgeSubscribe;

import com.google.common.collect.Lists;

public class MySoundManager {

	String[][] soundNames = new String[][]{{"humfade"}, {"soul1", "soul2", "soul3"}, {"pop1", "pop2"}, {"zoom"}, {"deflatedDeath1", "deflatedDeath2"}, {"spin"}, {"bubbles1", "bubbles2"}, {"bubblesloop"}};

	@ForgeSubscribe
	public void onSoundsLoaded(SoundLoadEvent e){
		Map map = Reflect.get(e.manager.soundPoolSounds, Reflect.nameToSoundPoolEntriesMapping, Map.class);
		if(map != null){
			for(int a = 0; a < soundNames.length; a++){
				String[] names = soundNames[a];
				for(int b = 0; b < names.length; b++){
					String name = names[b];
					URL url = MySoundManager.class.getResource(name + ".ogg");
					if(url != null){
						String par1Str = "clonecraft/" + name + ".ogg";
						String s1 = par1Str;
			            par1Str = par1Str.substring(0, par1Str.indexOf("."));

			            if (names.length > 1)
			            {
			                while (Character.isDigit(par1Str.charAt(par1Str.length() - 1)))
			                {
			                    par1Str = par1Str.substring(0, par1Str.length() - 1);
			                }
			            }

			            par1Str = par1Str.replaceAll("/", ".");
			            Object object = (List)map.get(par1Str);

			            if (object == null)
			            {
			                object = Lists.newArrayList();
			                map.put(par1Str, object);
			            }
			            ((List)object).add(new SoundPoolEntry(s1, url));
					}
				}
			}
		}
	}
}

